/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 202111231400
'Job.................:  
'Nome................: addcolumn 
'Objetivo............: Inserção/Atualização de novo campo na tabela;
'Tabelas.............: EST_ORC
'Dt Criação..........: 23/11/2021
'Dt Ult Alteracão....: --
'Criado por..........: Estevan Aquiles Pazzetti
'Alterado por........: --
'=======================================================================================
Ajuste de campo na tabela EST_ORC para atualização de tamanho do campo de endereço de cliente  (END_CLI);
*/

create or replace function addcolumn()
returns void as
$body$
begin

	IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'est_orc' AND COLUMN_NAME = 'end_cli') THEN
		ALTER TABLE EST_ORC ALTER COLUMN end_cli SET DATA TYPE varchar(150);
		RAISE NOTICE 'Coluna END_CLI alterado com sucesso!';		
	END IF;
	
	IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'est_orc' AND COLUMN_NAME = 'end_cli') THEN
		ALTER TABLE EST_ORC ADD COLUMN end_cli varchar(150);
		COMMENT ON COLUMN public.EST_ORC.end_cli IS 'Campo utilizado para informação de endereço do cliente';
		RAISE NOTICE 'Coluna END_CLI adicionada com sucesso!';
	ELSE
		RAISE NOTICE 'A coluna END_CLI já existe na tabela PRC_FILIAL.';
	END IF;
end; 
$body$
language plpgsql volatile
  cost 100;
alter function addcolumn()  owner to postgres;
select addcolumn();
drop function addcolumn();